const formidable = require("formidable");
const validator = require("validator");
const fs = require("fs");
const bcrypt = require("bcrypt");
const axios = require("axios");
const User = require("../models/authModel");
const Kelompok = require("../models/kelompokModel");

class dashboardKaprodiController {
  accKaprodi = async (req, res) => {
    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      try {
        const { code, dosen, inputan } = fields;
        console.log(fields);

        if (inputan == "0") {
          const limit = await User.findById(dosen);
          limit.kuota = `${parseInt(limit.kuota) + 1}`;
          limit.code = JSON.parse(limit.code);
          await User.findByIdAndUpdate(dosen, limit);
        } else if (inputan == "1") {
          const limit = await User.findById(dosen);

          const data = JSON.parse(limit.code);
          data.push(code);

          limit.code = data;
          await User.findByIdAndUpdate(dosen, limit);
        }

        const kel = await Kelompok.findById(code);
        kel.anggota = JSON.parse(kel.anggota);
        kel.acckaprodi = parseInt(inputan);
        await Kelompok.findByIdAndUpdate(code, kel);

        return res.render("sweet-alert", {
          icon: "success",
          message: "Your update successfull",
          redirectUrl: "/dashboard",
        });
      } catch {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Your update failed",
          redirectUrl: "/dashboard",
        });
      }
    });
  };

  chooseKaprodi = async (req, res) => {
    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      const { code, dosen } = fields;
      try {
        const limit = await User.findById(dosen);
        if (parseInt(limit.kuota) < 1) {
          return res.render("sweet-alert", {
            icon: "error",
            message: "Kuota dosen habis",
            redirectUrl: "/dashboard",
          });
        } else {
          limit.kuota = `${parseInt(limit.kuota) - 1}`;
          const calon = JSON.parse(limit.code);
          calon.push(code);
          limit.code = calon;
          await User.findByIdAndUpdate(dosen, limit);

          const kel = await Kelompok.findById(code);
          kel.dosen = dosen;
          kel.accdospem = 1;
          kel.acckaprodi = 1;
          kel.anggota = JSON.parse(kel.anggota);
          await Kelompok.findByIdAndUpdate(code, kel);

          return res.render("sweet-alert", {
            icon: "success",
            message: "Your choose successfull",
            redirectUrl: "/dashboard",
          });
        }
      } catch (error) {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Eror",
          redirectUrl: "/dashboard",
        });
      }
    });
  };

  statusAkhir = async (req, res) => {
    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      try {
        console.log(fields);
        const { code, inputan } = fields;
        const kel = await Kelompok.findById(code);
        kel.anggota = JSON.parse(kel.anggota);
        kel.lulus = inputan;
        await Kelompok.findByIdAndUpdate(code, kel);

        return res.render("sweet-alert", {
          icon: "success",
          message: "Your choose successfull",
          redirectUrl: "/dashboard",
        });
      } catch {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Your choose failed",
          redirectUrl: "/dashboard",
        });
      }
    });
  };
}

module.exports = new dashboardKaprodiController();
