const express = require("express");
const path = require("path");
const app = express();
const fs = require("fs");
const bodyParser = require("body-parser");
const session = require("express-session");
const flash = require("express-flash");
const cookieParser = require("cookie-parser");

const port = process.env.PORT || 8000;

app.set("views", "./view");
app.set("view engine", "ejs");
app.use(express.static(path.join(__dirname, "view")));

app.use(bodyParser.urlencoded({ extended: true }));

app.use(cookieParser());
app.use(
  session({
    secret: "754h5456f4",
    resave: true,
    saveUninitialized: true,
  })
);
app.use(flash());

fs.readdirSync(`${__dirname}/routes`).map((filename) => {
  app.use("/", require(path.join(`${__dirname}`, "/routes", `${filename}`).replace(".js", "")));
});

app.get("/", (req, res) => {
  res.sendFile(process.cwd() + "/view/home.html");
});

app.get("/panitia", (req, res) => {
  res.sendFile(process.cwd() + "/view/panitia.html");
});

app.get("/pedoman", (req, res) => {
  res.sendFile(process.cwd() + "/view/pedoman.html");
});

app.get("/logout", (req, res) => {
  res.clearCookie("curdToken");
  res.redirect("/");
});

app.use("*", (req, res) => {
  res.redirect("/");
});

require("./config/dbConnect");

app.listen(port, () => {
  console.log(`Server is running port ${port}`);
});
