const formidable = require("formidable");
const validator = require("validator");
const fs = require("fs");
const bcrypt = require("bcrypt");
const axios = require("axios");
const User = require("../models/authModel");
const Kelompok = require("../models/kelompokModel");

class dashboardDospemController {
  accDospem = async (req, res) => {
    const { id } = req.userInfo;
    const userInfo = await User.findById(id);

    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      try {
        const { code, inputan } = fields;

        if (inputan == "0") {
          const limit = await User.findById(userInfo.nomor_induk);
          limit.kuota = `${parseInt(limit.kuota) + 1}`;
          limit.code = JSON.parse(limit.code);
          await User.findByIdAndUpdate(userInfo.nomor_induk, limit);
        }

        const kel = await Kelompok.findById(code);
        kel.anggota = JSON.parse(kel.anggota);
        kel.accdospem = parseInt(inputan);
        await Kelompok.findByIdAndUpdate(code, kel);

        return res.render("sweet-alert", {
          icon: "success",
          message: "Your update successfull",
          redirectUrl: "/dashboard",
        });
      } catch {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Your update failed",
          redirectUrl: "/dashboard",
        });
      }
    });
  };

  komentarSatu = async (req, res) => {
    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      try {
        const { code, komentar1 } = fields;

        const kel = await Kelompok.findById(code);
        kel.komentarLaporanSatu = komentar1;
        kel.anggota = JSON.parse(kel.anggota);
        await Kelompok.findByIdAndUpdate(code, kel);

        return res.render("sweet-alert", {
          icon: "success",
          message: "Your comment successfull",
          redirectUrl: "/dashboard",
        });
      } catch {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Your comment failed",
          redirectUrl: "/dashboard",
        });
      }
    });
  };

  komentarDua = async (req, res) => {
    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      try {
        const { code, komentar2 } = fields;

        const kel = await Kelompok.findById(code);
        kel.komentarLaporanDua = komentar2;
        kel.anggota = JSON.parse(kel.anggota);
        await Kelompok.findByIdAndUpdate(code, kel);

        return res.render("sweet-alert", {
          icon: "success",
          message: "Your comment successfull",
          redirectUrl: "/dashboard",
        });
      } catch {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Your comment failed",
          redirectUrl: "/dashboard",
        });
      }
    });
  };

  komentarTiga = async (req, res) => {
    const form = formidable({ multiples: true });
    form.parse(req, async (err, fields, files) => {
      try {
        const { code, komentar3 } = fields;

        const kel = await Kelompok.findById(code);
        kel.komentarLaporanTiga = komentar3;
        kel.anggota = JSON.parse(kel.anggota);
        await Kelompok.findByIdAndUpdate(code, kel);

        return res.render("sweet-alert", {
          icon: "success",
          message: "Your comment successfull",
          redirectUrl: "/dashboard",
        });
      } catch {
        return res.render("sweet-alert", {
          icon: "error",
          message: "Your comment failed",
          redirectUrl: "/dashboard",
        });
      }
    });
  };
}

module.exports = new dashboardDospemController();
